import re
import random

def grepper(fname,pattern,measuresIn='All_Measures.csv'):
    p = re.compile(pattern)
    with open(measuresIn) as file, open(fname,"w") as fout:
        print(file.readline(),end="",file=fout)
        for line in file:
            if p.match(line):
                print(line,end="",file=fout)

def countRuns(measuresIn='All_Measures.csv'):
    nlines = 0
    with open(measuresIn) as file:
        file.readline()
        for line in file:
            nlines += 1
    return nlines

def randomSample(fname,k,measuresIn='All_Measures.csv'):
    with open(measuresIn) as file, open(fname,"w") as fout:
        print(file.readline(),end="",file=fout)
        for line in random.sample(file.readlines(),k):
            print(line,end="",file=fout)

def randomPartition(fname,N,measuresIn='All_Measures.csv'):
    with open(measuresIn) as file:
        firstline=file.readline()
        runs = file.readlines()
    random.shuffle(runs)
    for i in range(N):
        fname_i = fname.format(i=i)
        print(f"Random subset {i} to {fname_i} ...")
        with open(fname_i,"w") as fout:
            print(firstline,end="",file=fout)
            for line in runs[i::N]:
                print(line,end="",file=fout)
                
if False:
    batchname = "BFMv3"
    grepper(f"RunMeasures_{batchname}_batch1.csv",r".*,(CZ01|CZ09),.*")
    grepper(f"RunMeasures_{batchname}_batch2.csv",r".*,(CZ02|CZ10),.*")
    grepper(f"RunMeasures_{batchname}_batch3.csv",r".*,(CZ03|CZ11),.*")
    grepper(f"RunMeasures_{batchname}_batch4.csv",r".*,(CZ04|CZ12),.*")
    grepper(f"RunMeasures_{batchname}_batch5.csv",r".*,(CZ05|CZ13),.*")
    grepper(f"RunMeasures_{batchname}_batch6.csv",r".*,(CZ06|CZ14),.*")
    grepper(f"RunMeasures_{batchname}_batch6.csv",r".*,(CZ07|CZ15),.*")
    grepper(f"RunMeasures_{batchname}_batch6.csv",r".*,(CZ08|CZ16),.*")

if True:
    batchname = "BFMv3"
    fname = f"RunMeasures_{batchname}_part7_subpart{{i}}.csv"
    randomPartition(fname,8,"RunMeasures_BFMv3_batch7.csv")


